/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.jspemul;

import com.ibm.hwmca.fw.servlet.jspemul.BodyContentEmul;
import com.ibm.hwmca.fw.servlet.jspemul.JspWriterEmul;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;

class PageContextEmul
extends PageContext {
    private static final String TRACE_MASKT = "XJSPPCXT";
    private static final String TRACE_MASKD = "XJSPPCXD";
    private HttpServlet servlet;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String errorPageURL;
    private boolean needsSession;
    private int bufferSize;
    private boolean autoFlush;
    private HashMap pageScopeAttributes = new HashMap();
    private JspWriterEmul baseOut;
    private JspWriter out;
    private BodyContentEmul[] bodyContentStack;
    private int stackSize;

    PageContextEmul() {
    }

    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) throws IOException, IllegalStateException, IllegalArgumentException {
        Trace.trace(TRACE_MASKD, "Initializing PageContextEmul " + System.identityHashCode((Object)this));
        this.servlet = (HttpServlet)servlet;
        this.request = (HttpServletRequest)request;
        this.response = (HttpServletResponse)response;
        this.errorPageURL = errorPageURL;
        this.needsSession = needsSession;
        this.bufferSize = bufferSize;
        this.autoFlush = autoFlush;
        if (needsSession && this.getSession() == null) {
            throw new IllegalStateException("Page needs a session and none is available");
        }
        if (this.baseOut == null) {
            this.baseOut = new JspWriterEmul(response, bufferSize, autoFlush);
        } else {
            this.baseOut.init(response, bufferSize, autoFlush);
        }
        this.out = this.baseOut;
        this.stackSize = 0;
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        this.setAttribute("javax.servlet.jsp.jspRequest", request);
        this.setAttribute("javax.servlet.jsp.jspResponse", response);
        if (this.getSession() != null) {
            this.setAttribute("javax.servlet.jsp.jspSession", this.getSession());
        }
        this.setAttribute("javax.servlet.jsp.jspPage", servlet);
        this.setAttribute("javax.servlet.jsp.jspConfig", this.getServletConfig());
        this.setAttribute("javax.servlet.jsp.jspPageContext", (Object)this);
        this.setAttribute("javax.servlet.jsp.jspApplication", this.getServletContext());
    }

    public void release() {
        Trace.trace(TRACE_MASKD, "Releasing PageContextEmul " + System.identityHashCode((Object)this));
        this.servlet = null;
        this.request = null;
        this.response = null;
        this.errorPageURL = null;
        this.pageScopeAttributes.clear();
        try {
            this.baseOut.flushOutputBuffer();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKT, "Ignoring unexpected I/O error flushing page content on release()");
            Trace.trace(TRACE_MASKT, e);
        }
        this.stackSize = 0;
        this.baseOut.recycle();
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public Object getPage() {
        return this.servlet;
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public Exception getException() {
        return null;
    }

    public ServletConfig getServletConfig() {
        return this.servlet.getServletConfig();
    }

    public ServletContext getServletContext() {
        return this.servlet.getServletContext();
    }

    public void forward(String relativeUrlPath) throws ServletException, IOException {
        Trace.trace(TRACE_MASKT, "Rejecting call to unsupported PageContext.forward(String) method");
        throw new UnsupportedOperationException("PageContext.forward() is not supported in the JSP emulator");
    }

    public void include(String relativeUrlPath) throws ServletException, IOException {
        Trace.trace(TRACE_MASKT, "Rejecting call to unsupported PageContext.include(String) method");
        throw new UnsupportedOperationException("PageContext.include() is not supported in the JSP emulator");
    }

    public void include(String relativeUrlPath, boolean flush) throws ServletException, IOException {
        Trace.trace(TRACE_MASKT, "Rejecting call to unsupported PageContext.include(String, boolean) method");
        throw new UnsupportedOperationException("PageContext.include() is not supported in the JSP emulator");
    }

    public void handlePageException(Exception e) throws ServletException, IOException {
        this.handlePageException(e);
    }

    public void handlePageException(Throwable throwable) throws ServletException, IOException {
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (throwable instanceof ServletException) {
            throw (ServletException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof JspException) {
            Throwable rootCause = ((JspException)throwable).getRootCause();
            if (rootCause != null) {
                throw new ServletException(throwable.getMessage(), rootCause);
            }
            throw new ServletException(throwable);
        }
        throw new ServletException(throwable);
    }

    public BodyContent pushBody() {
        if (this.bodyContentStack == null) {
            Trace.trace(TRACE_MASKD, "Creating BodyContent stack for PageContextEmul " + System.identityHashCode((Object)this));
            this.bodyContentStack = new BodyContentEmul[10];
            this.stackSize = 0;
        } else if (this.stackSize == this.bodyContentStack.length) {
            BodyContentEmul[] old = this.bodyContentStack;
            this.bodyContentStack = new BodyContentEmul[old.length + 10];
            System.arraycopy(old, 0, this.bodyContentStack, 0, old.length);
            Trace.trace(TRACE_MASKD, "Extending BodyContent stack for PageContextEmul " + System.identityHashCode((Object)this) + ". New size is " + this.bodyContentStack.length);
        }
        int i = this.stackSize++;
        if (this.bodyContentStack[i] == null) {
            Trace.trace(TRACE_MASKD, "Creating new BodyContent object for PageContextEmul " + System.identityHashCode((Object)this));
            this.bodyContentStack[i] = new BodyContentEmul(this.out);
        } else {
            Trace.trace(TRACE_MASKD, "Reusing BodyContent object for PageContextEmul " + System.identityHashCode((Object)this));
            this.bodyContentStack[i].clearBody();
        }
        this.out = this.bodyContentStack[i];
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        return (BodyContent)this.out;
    }

    public JspWriter popBody() {
        Trace.trace(TRACE_MASKD, "Popping BodyContent object for PageContextEmul " + System.identityHashCode((Object)this));
        if (this.stackSize == 0) {
            throw new IllegalStateException("PageContext.popBody() called when BodyContent stack is empty.");
        }
        --this.stackSize;
        this.out = this.stackSize != 0 ? this.bodyContentStack[this.stackSize - 1] : this.baseOut;
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        return this.out;
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(name, value, 1);
    }

    public void setAttribute(String name, Object value, int scope) {
        switch (scope) {
            case 1: {
                if (value == null) {
                    this.pageScopeAttributes.remove(name);
                    break;
                }
                this.pageScopeAttributes.put(name, value);
                break;
            }
            case 2: {
                this.request.setAttribute(name, value);
                break;
            }
            case 3: {
                HttpSession session = this.getSession();
                if (session == null) {
                    throw new IllegalStateException("No session exists to set attribute in.");
                }
                session.setAttribute(name, value);
                break;
            }
            case 4: {
                this.getServletContext().setAttribute(name, value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown scope value " + scope + " specified.");
            }
        }
    }

    public Object getAttribute(String name) {
        return this.pageScopeAttributes.get(name);
    }

    public Object getAttribute(String name, int scope) {
        switch (scope) {
            case 1: {
                return this.pageScopeAttributes.get(name);
            }
            case 2: {
                return this.request.getAttribute(name);
            }
            case 3: {
                HttpSession session = this.getSession();
                if (session == null) {
                    throw new IllegalStateException("No session exists to get attribute from.");
                }
                return session.getAttribute(name);
            }
            case 4: {
                return this.getServletContext().getAttribute(name);
            }
        }
        throw new IllegalArgumentException("Unknown scope value " + scope + " specified.");
    }

    public Object findAttribute(String name) {
        Object value = this.pageScopeAttributes.get(name);
        if (value != null) {
            return value;
        }
        value = this.request.getAttribute(name);
        if (value != null) {
            return value;
        }
        HttpSession session = this.getSession();
        if (session != null && (value = session.getAttribute(name)) != null) {
            return value;
        }
        return this.getServletContext().getAttribute(name);
    }

    public void removeAttribute(String name) {
        this.pageScopeAttributes.remove(name);
        this.request.removeAttribute(name);
        HttpSession session = this.getSession();
        if (session != null) {
            session.removeAttribute(name);
        }
        this.getServletContext().removeAttribute(name);
    }

    public void removeAttribute(String name, int scope) {
        switch (scope) {
            case 1: {
                this.pageScopeAttributes.remove(name);
                break;
            }
            case 2: {
                this.request.removeAttribute(name);
                break;
            }
            case 3: {
                HttpSession session = this.getSession();
                if (session == null) {
                    throw new IllegalStateException("No session exists to remove attribute from.");
                }
                session.removeAttribute(name);
                break;
            }
            case 4: {
                this.getServletContext().removeAttribute(name);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown scope value " + scope + " specified.");
            }
        }
    }

    public int getAttributesScope(String name) {
        if (this.pageScopeAttributes.containsKey(name)) {
            return 1;
        }
        if (this.request.getAttribute(name) != null) {
            return 2;
        }
        HttpSession session = this.getSession();
        if (session != null && session.getAttribute(name) != null) {
            return 3;
        }
        if (this.getServletContext().getAttribute(name) != null) {
            return 4;
        }
        return 0;
    }

    public Enumeration getAttributeNamesInScope(int scope) {
        switch (scope) {
            case 1: {
                return Collections.enumeration(this.pageScopeAttributes.keySet());
            }
            case 2: {
                return this.request.getAttributeNames();
            }
            case 3: {
                HttpSession session = this.getSession();
                if (session == null) {
                    throw new IllegalStateException("No session exists to get attributes from.");
                }
                return session.getAttributeNames();
            }
            case 4: {
                return this.getServletContext().getAttributeNames();
            }
        }
        throw new IllegalArgumentException("Unknown scope value " + scope + " specified.");
    }

    public JspWriter getOut() {
        return this.out;
    }
}

